(() => {
const canvas = document.getElementById("counter");
const ctx = canvas.getContext("2d");
// オフスクリーン・キャンバス（下書き用）
const offCanvas = document.createElement("canvas");
offCanvas.width = canvas.width;
offCanvas.height = canvas.height;
const offCtx = offCanvas.getContext("2d");
let currentCount = "LOAD!!"; // 初期表示
let frame = 0;
// --- 1. fetchによるデータ取得関数 ---
async function fetchCounter() {
  try {
    const response = await fetch('./count.cgi', { cache: "no-store" });  //ファイルの設置場所に合わせて変更を！
      if (!response.ok) throw new Error('Network error');
        const countData = await response.text();
        // 数値を6桁に整形 (例: 123 -> "000123")
        currentCount = String(countData.trim()).padStart(6, '0');
  } catch (error) {
    currentCount = "ERROR!"; // エラー時の表示
  }
}
// --- 2. 描画ループ ---
function draw() {
  // 1. 下書き用キャンバスをクリアして文字を描画
  offCtx.clearRect(0, 0, offCanvas.width, offCanvas.height);
  offCtx.fillStyle = "#00FF55";
  offCtx.font = "16px 'Courier New', monospace";
  offCtx.textBaseline = "middle";
  offCtx.textAlign = "center";
  // 文字を下書きに描く
  offCtx.fillText(currentCount, offCanvas.width / 2, offCanvas.height / 2);
  // 2. メインキャンバスをクリア
  ctx.fillStyle = "#000";
  ctx.fillRect(0, 0, canvas.width, canvas.height);
  // 3. ラスタースクロール処理（1ピクセルずつ横にずらしてコピー）
  for (let y = 0; y < canvas.height; y++) {
    // サイン波を使って、y座標（行）ごとに横のズレ（xOffset）を計算
    const xOffset = Math.sin((frame / 30) + (y / 10)) * 2;
    // drawImage(画像, ソースx, ソースy, ソース幅, ソース高, 先x, 先y, 先幅, 先高)
    ctx.drawImage(
      offCanvas, 
      0, y, canvas.width, 1,      // 下書きのy行目、1ピクセル分を切り取る
      xOffset, y, canvas.width, 1 // メインにxOffset分だけずらして貼り付け
    );
  }
  // 4. 仕上げの走査線
  ctx.fillStyle = "rgba(0, 255, 0, 0.05)";
  for (let i = 0; i < canvas.height; i += 2) {
    ctx.fillRect(0, i, canvas.width, 1);
  }
  frame++;
  requestAnimationFrame(draw);
}
// 実行開始
fetchCounter(); // データを取得しに行く
draw();         // アニメーションを開始する
})();